<?php

/*
 * Plugin Name: BC Sailing Schedule
Plugin URI:  https://web321.co/our-plugins/bc-ferries/
Description: Displays sailing schedule information from a remote JSON data source. Uses the https://www.bcferriesapi.ca/ as a data source
Version:     1.0.1
Author:      Shawn DeWolfe (dewolfe001)
Author URI:  https://web321.co
Donate: https://www.paypal.com/paypalme/web321co/20/
Requires at least: 5.9
Tested up to: 6.1.1
License:     GPL2License URI: https://www.gnu.org/licenses/gpl-2.0.html
*/

defined( 'ABSPATH' ) or die( 'No script help, please!' );

define('SDCH_BCFERRIES_MAIN', __FILE__);
define('SDCH_BCFERRIES_NAME', plugin_basename( __FILE__ ));
define('SDCH_BCFERRIES_PATH', plugin_dir_path(__FILE__));
define('SDCH_BCFERRIES_URL', plugin_dir_url(__FILE__));
define("SDCH_BCFERRIES_SRC", "https://www.bcferriesapi.ca/api/");

$sdch_friendly = [
	"TSA" => 'Tsawwassen', 
	"SWB" => 'Swartz Bay', 
	"SGI" => 'Southern Gulf Islands', 
	"DUK" => 'Duke Point (Nanaimo)', 
	"FUL" => 'Fulford Harbour (Salt Spring Island)', 
	"HSB" => 'Horseshoe Bay (Nanaimo)', 
	"NAN" => 'Departure Bay (Nanaimo)', 
	"LNG" => 'Langford', 
	"BOW" => 'Bowen Island'
];

include_once 'shortcodes.php';

function sdch_get_bcferriesjson($atts) {
	$phrase = $atts['departure'].'_'.$atts['destination'];
	$args = '';
	if ($atts['departure']) {
		$args .= $atts['departure'].'/';
	}
	if ($atts['destination']) {
		$args .= $atts['destination'].'/';
	}
	$lastcheck = intval(get_option('bcferries_'.$phrase.'_lastcheck'));
	$json_data = get_option('bcferries_'.$phrase.'_data');
	
	if ($lastcheck < (time() - 1800)) {
		// fetch fresh data
	    $json_url = SDCH_BCFERRIES_SRC.$args; // replace with your JSON data source URL
	    $json_data = file_get_contents($json_url);

		update_option('bcferries_'.$phrase.'_lastcheck', time());
		update_option('bcferries_'.$phrase.'_data', $json_data);	
	}

	// get from the options store

	// if can't get it, then load and store

	return $json_data;
}

// donation link
add_filter( 'plugin_row_meta', 'bcferries_row_meta', 10, 2 );
function bcferries_row_meta( $links, $file ) {    
    if (SDCH_BCFERRIES_NAME == $file ) {
        $row_meta = array(
          'donatewp'    => '<a href="' . esc_url( 'https://www.paypal.com/paypalme/web321co/20/' ) . '" target="_blank" aria-label="' . esc_attr__( 'Donate to Web321', 'bc-ferries' ) . '" >' . esc_html__( 'Donate', 'bc-ferries' ) . '</a>',
          'donategit'    => '<a href="' . esc_url( 'https://github.com/sponsors/samuel-pratt' ) . '" target="_blank" aria-label="' . esc_attr__( 'Donate to Sam Pratt', 'bc-ferries' ) . '" >' . esc_html__( 'Support Sam Pratt', 'bc-ferries' ) . '</a>'
        );

        return array_merge( $links, $row_meta );
    }
    return (array) $links;
}