<?php

function sdch_bcferries_shortcode($atts = array(), $content = "") {
	global $sdch_friendly;
	$atts = shortcode_atts( array(
		'id' => 'siv_'.crypt(date("s"), 'st'),
		'departure' => '',
		'destination' => '',
		'limit' => '-1'
	), $atts, 'sdch' );

	$json_data = sdch_get_bcferriesjson($atts);
	$schedule = json_decode($json_data, true);
    $output = '';

	$args = '';
	if ($atts['departure']) {
		$args = ' from ';
		$args .= $sdch_friendly[$atts['departure']];
	}
	if ($atts['destination']) {
		$args .= ' to '.$sdch_friendly[$atts['destination']];
	}

    // check if the schedule data is valid
    if (is_array($schedule) && !empty($schedule)) {
        $output .= '<h2>Sailing Schedule'.$args.'</h2>';
        foreach ($schedule as $route => $data) {
            $output .= '<h3>' .$sdch_friendly[$route]. ' (' . $route . ')</h3>';
            foreach ($data['sailings'] as $sailing) {
                $output .= '<p>' . $sailing['vesselName'] . ' - ' . $sailing['time'] . '</p>';
            }
        }
    } else {
        $output .= '<p>Unable to retrieve sailing schedule information.</p>';
    }
    return $output;
}

// register shortcode
function sdch_bcferries_shortcode_list() {
    add_shortcode( 'sdch_bcferries', 'sdch_bcferries_shortcode' );
}

add_action( 'init', 'sdch_bcferries_shortcode_list' );