<?php
/*
Plugin Name: Web321 Improved Video Display
Plugin URI:  https://web321.co/our-plugins/improved-video/
Description: Load an embed when user clicks on the image. It defers the loading until the user takes a manual action.
Version:     1.0.1
Author:      Shawn DeWolfe (dewolfe001)
Author URI:  https://web321.co
Donate: https://www.paypal.com/paypalme/web321co/20/
Requires at least: 5.9
Tested up to: 6.1.1
License:     GPL2License URI: https://www.gnu.org/licenses/gpl-2.0.html
*/

defined( 'ABSPATH' ) or die( 'No script help, please!' );

define('SDCH_IMPVIDEO_MAIN', __FILE__);
define('SDCH_IMPVIDEO_NAME', plugin_basename( __FILE__ ));
define('SDCH_IMPVIDEO_PATH', plugin_dir_path(__FILE__));
define('SDCH_IMPVIDEO_URL', plugin_dir_url(__FILE__));

include_once 'shortcode.php';


// donation link
add_filter( 'plugin_row_meta', 'improved_video_row_meta', 10, 2 );
function improved_video_row_meta( $links, $file ) {    
    if (SDCH_IMPVIDEO_NAME == $file ) {
        $row_meta = array(
          'donate'    => '<a href="' . esc_url( 'https://www.paypal.com/paypalme/web321co/20/' ) . '" target="_blank" aria-label="' . esc_attr__( 'Donate', 'improved-video' ) . '" >' . esc_html__( 'Donate', 'improved-video' ) . '</a>'
        );

        return array_merge( $links, $row_meta );
    }
    return (array) $links;
}