<?php

/* ----- SHORTCODES -------------*/

function sdch_shortcode_video($atts = array(), $content = "") {
	global $post;
	$atts = shortcode_atts( array(
		'id' => 'siv_'.crypt(date("s"), 'st'),
		'title' => '',
		'image' => '',
		'width' => '-1',
		'height' => '-1',
		'size' => 'large',
		'extra' => ''
	), $atts, 'sdch' );

	// do we have an image?

	$embed = '';
	// what about the $content?
	if (strpos($content, 'iframe') > 0) {
		$embed = $content;	
		$unique_id = 'imp_'.substr(md5($embed), 0, 12);
		if (preg_match('/src="([^"]+)"/', $embed, $matches)) {
			$src = $matches[1];
			$embed = str_replace($src, $src.'&autoplay=1', $embed);
			$embed = str_replace('></iframe>', ' style="width: 100%; height: 102% !important;"></iframe>', $embed);
		}
	}

	$image = "";
	$ratio = "";
	// image finder
	if (is_numeric($atts['image'])) {
		if (($atts['width'] > 1) && ($atts['height'] > 1)) {
			// use the array
			$size = array($atts['width'], $atts['height']);
		}
		else {
			$size = $atts['size'];
		}
		if ($img = wp_get_attachment_image_src($atts['image'], $size)) {
			$image = $img[0];
			$padratio = ($img[1] / (($img[2] - 24) * 2)) * 100;
			$ratio = 'padding-top: '.$padratio.'%; padding-bottom: '.$padratio.'%;';
		}
	}

	if ($image == "") {
		// assume we have a URL
		$image = $atts['image'];
		if (($atts['width'] > 1) && ($atts['height'] > 1)) {
			// use the array
			$padratio = (($atts['height'] - 24) / $atts['width']) * 50;
			$ratio = 'width: 100%; padding-top: '.$padratio.'%; padding-bottom: '.$padratio.'%;';
		}
	}

	$output = '<!-- no video found -->';
	if (strlen($embed) > 0) {
		$find_arr = [' ', '"', "'"];
		$repl_arr = ['^', 'µ', '»'];
		$alt_embed = str_replace($find_arr, $repl_arr, $embed);
		
		$css = sprintf('style="background-image: url(%s); %s%s"', $image, $ratio, $atts['extra']);
		$output = sprintf('<div class="sdch_impvideo" id="%s"/>', $unique_id);
		$output .= sprintf('<div class="sdch_embed" data-embed="%s"%s/></div>', $alt_embed, $css);
		$output .= '</div>';

		wp_enqueue_script( 'sdch_impvideo', SDCH_IMPVIDEO_URL.'assets/sdc_improved_video.js', array('jquery'), '1.0.1', true );
		wp_enqueue_style( 'sdch_impvideo', SDCH_IMPVIDEO_URL.'assets/sdc_improved_video.css' );      
	}
	return $output;
}

// register shortcode
function sdch_impvideo_shortcode() {
    add_shortcode( 'sdch_video', 'sdch_shortcode_video' );
}

add_action( 'init', 'sdch_impvideo_shortcode' );